from mpi4py import MPI
import numpy as np

# Parametres globaux
nb_valeurs = 1000
etiquette = 99

# Initialisation MPI & recuperation du rang
comm = MPI.COMM_WORLD
rang = comm.Get_rank()

# Initialisation a zero de valeurs
valeurs = np.zeros(nb_valeurs, dtype=np.float64)

# Graine pour le generateur aleatoire
np.random.seed(42)

if rang == 0:
    # Remplir avec des nombres aleatoires
    valeurs = np.random.rand(nb_valeurs)
    # Processus 0 envoie valeurs au processus 1
    comm.Send(valeurs, dest=1, tag=etiquette)
elif rang == 1:
    # Processus 1 recoit valeurs du processus 0
    comm.Recv(valeurs, source=0, tag=etiquette)
    print(f"Moi, processus 1, j'ai recu {nb_valeurs} "
          f"valeurs (derniere = {valeurs[-1]:.2f}) du processus 0.")
