from mpi4py import MPI
import numpy as np

# Recuperation du rang -> rang
comm = MPI.COMM_WORLD
rang = comm.Get_rank()

nb_valeurs = 1000
etiquette = 99

# Creation du tableau valeurs
valeurs = np.zeros(nb_valeurs, dtype=np.float64)

# Graine du generateur aleatoire
np.random.seed(42)

if rang == 0:
    # Remplir valeur avec des valeurs aleatoires sur le processus 0
    valeurs = np.random.rand(nb_valeurs)
    # Debut de prise de temps du ping pong -> temps_debut
    temps_debut = MPI.Wtime()
    # Processus 0: envoie et recoit du processus 1
    comm.Send(valeurs, dest=1, tag=etiquette)
    comm.Recv(valeurs, source=1, tag=etiquette)
    # Fin de prise de temps du ping pong -> temps_fin
    temps_fin = MPI.Wtime()
    print(f"Moi, processus 0, j'ai envoye et recu {nb_valeurs} "
          f"valeurs (derniere = {valeurs[-1]:.2f}) du processus 1 en "
          f"{temps_fin - temps_debut:.6f} secondes.")
elif rang == 1:
    # Processus 1: recoit et envoie au processus 0
    comm.Recv(valeurs, source=0, tag=etiquette)
    comm.Send(valeurs, dest=0, tag=etiquette)
