from mpi4py import MPI
import numpy as np

# Parametres
nb_valeurs_max = 7000000
nb_tests = 10
etiquette = 99

# Recuperation du rang -> rang
comm = MPI.COMM_WORLD
rang = comm.Get_rank()

# Creation du tableau valeurs
valeurs = np.zeros(nb_valeurs_max, dtype=np.float64)

# Listes des tailles de messages a tester
nb_valeurs = [0, 0, 1, 10, 100, 1000, 10000, 100000, 1000000, 7000000]

for nb_valeur in nb_valeurs:
    # Faire un ping pong pour chaque taille
    if rang == 0:
        valeurs = np.random.rand(nb_valeurs_max)
        # Debut de la prise de temps du ping pong -> temps_debut
        temps_debut = MPI.Wtime()
        # Processus 0: Envoie et recoit du processus 1
        comm.Send([valeurs, nb_valeur], dest=1, tag=etiquette)
        comm.Recv([valeurs, nb_valeur], source=1, tag=etiquette)
        # Fin de la prise de temps du ping pong -> temps_fin
        temps_fin = MPI.Wtime()
        debit = (2 * nb_valeur * 8) / 1000000 / (temps_fin - temps_debut)
        if nb_valeur != 0:
            print(f"Moi, processus 0, j'ai envoye et recu {nb_valeur} "
                  f"valeurs (derniere = {valeurs[nb_valeur - 1]:.2f}) "
                  f"du processus 1 en {temps_fin - temps_debut:.6f} secondes,"
                  f" avec un debit de {debit:.2f} Mo/s.")
        else:
            print(f"Moi, processus 0, j'ai envoye et recu {nb_valeur} "
                  f"valeurs en {temps_fin - temps_debut:.6f} secondes, "
                  f"avec un debit de {debit:.2f} Mo/s.")
    elif rang == 1:
        # Processus 1: Recoit et envoie au processus 0
        comm.Recv([valeurs, nb_valeur], source=0, tag=etiquette)
        comm.Send([valeurs, nb_valeur], dest=0, tag=etiquette)
