from mpi4py import MPI
import math

# Initialisation de la bibliothèque MPI
comm = MPI.COMM_WORLD
rang = comm.Get_rank()
nb_procs = comm.Get_size()

# Nombre d'intervalles
nbblock = 3 * 1000 * 1000 * 100
# Largeur des intervalles
largeur = 1.0 / nbblock

somme_locale = 0.0

# Distribution progressive
debut = (rang * nbblock) // nb_procs + 1
fin = ((rang + 1) * nbblock) // nb_procs

# Les restes sont distribues sur les premiers rangs
# debut = rang * (nbblock // nb_procs) + 1 + min(rang, nbblock % nb_procs)
# fin = debut + (nbblock // nb_procs) - 1
# if rang < nbblock % nb_procs:
#  fin += 1

# Les restes sont distribues sur les derniers rangs
# debut = rang * (nbblock // nb_procs) + 1 + \
# max(nbblock % nb_procs + rang - nb_procs, 0)
# fin = debut + (nbblock + rang) // nb_procs - 1

print(f"{rang} debut: {debut} fin: {fin} delta: {fin-debut+1}")

# Calcul de la somme locale
for i in range(debut, fin + 1):
    x = largeur * (i - 0.5)
    somme_locale += largeur * (4.0 / (1.0 + x * x))

# Calcul de la somme globale
somme_globale = comm.reduce(somme_locale, op=MPI.SUM)

if rang == 0:
    print(f"Pi = {somme_globale}")
    print(f"Difference = {somme_globale - 4.0 * math.atan(1.0)}")

nb_iterations = comm.reduce(fin - debut + 1, op=MPI.SUM)

if rang == 0:
    print(f"Nb = {nb_iterations}")
