from mpi4py import MPI
import numpy as np

nb_lignes = 5
nb_colonnes = 4
nb_lignes_t = nb_colonnes
nb_colonnes_t = nb_lignes
etiquette = 1000

# Recuperation du rang -> rang
comm = MPI.COMM_WORLD
rang = comm.Get_rank()

# Matrices
A = np.zeros((nb_lignes, nb_colonnes))
AT = np.zeros((nb_lignes_t, nb_colonnes_t), dtype=np.float64)

# Type colonne pour AT
float_mpi = MPI.DOUBLE
type_colonne = float_mpi.Create_vector(nb_lignes_t, 1, nb_colonnes_t)
deplacement = float_mpi.Get_size()
# Type transpose pour AT
type_transpose = type_colonne.Create_hvector(nb_colonnes_t, 1, deplacement)
# Validation du type type_transpose
type_transpose.Commit()

if rang == 0:
    # Initialisation de la matrice A sur le processus 0
    A = np.reshape(np.arange(1, nb_lignes * nb_colonnes + 1, dtype=np.float64),
                   (nb_lignes, nb_colonnes))
    print("Matrice A")
    print(A)
    # Processus 0: Envoie la matrice A au processus 1
    comm.Send([A, nb_colonnes*nb_lignes, MPI.DOUBLE], dest=1, tag=etiquette)
else:
    # Processus 1: Recoit dans la matrice AT du processus 0
    comm.Recv([AT, 1, type_transpose], source=0, tag=etiquette)
    print("Matrix transpose AT")
    print(AT)
