from mpi4py import MPI
import numpy as np

# Recuperation du rang et du nombre de processus
comm = MPI.COMM_WORLD
nbprocs = comm.Get_size()
rang = comm.Get_rank()

dimCart2D = [4, 2]

if dimCart2D[0]*dimCart2D[1] != nbprocs:
    print("Le nombre de processus n'est pas correct!")
    # On arrete le programme
    comm.Abort(errorcode=1)
# Creation de la topologie -> commCart2D
commCart2D = comm.Create_cart(dimCart2D)
# Recuperation des coordonnees dans la topologie
rang = commCart2D.Get_rank()
coordCart2D = commCart2D.Get_coords(rang)

# Initialisation de v et w
if (coordCart2D[0] == 1):
    v = np.array([1, 2, 3, 4], dtype=np.float64)
else:
    v = None
w = np.zeros(1, dtype=np.float64)

# Subdivision de la topologie avec split
commCart1D = commCart2D.Split(color=coordCart2D[1])
# Diffusion de v vers w par le processus 1 dans la nouvelle topologie
commCart1D.Scatter(sendbuf=[v, 1, MPI.DOUBLE],
                   recvbuf=[w, 1, MPI.DOUBLE], root=1)

print(f"Rang : {rang} ; Coordonnees ({coordCart2D[0]}, {coordCart2D[1]}) "
      f"; w = {w}")
