from mpi4py import MPI
import numpy as np

nb_valeurs = 121
valeurs = np.zeros(nb_valeurs, dtype=np.int32)

comm = MPI.COMM_WORLD
rang = comm.Get_rank()

# Ouverture du fichier data.dat en lecture
fh = MPI.File.Open(comm, "data.dat", MPI.MODE_RDONLY)

# Lecture avec des deplacements explicit en mode individuel
nb_octets_int32 = MPI.INT.Get_size()
deplacement = rang * nb_valeurs * nb_octets_int32
fh.Read_at(deplacement, [valeurs, nb_valeurs, MPI.INT])
filename = f"file_dei{rang}.dat"
np.savetxt(filename, valeurs, fmt='%3d')

valeurs = np.zeros(nb_valeurs, dtype=np.int32)
# Lecture avec les pointeurs partages en mode collectif
fh.Read_ordered([valeurs, nb_valeurs, MPI.INT])
filename = f"file_ppc{rang}.dat"
np.savetxt(filename, valeurs, fmt='%3d')

valeurs = np.zeros(nb_valeurs, dtype=np.int32)
# Lecture avec les pointeurs individuels en mode individuel
fh.Seek(deplacement, MPI.SEEK_SET)
fh.Read([valeurs, nb_valeurs, MPI.INT])
filename = f"file_pii{rang}.dat"
np.savetxt(filename, valeurs, fmt='%3d')

valeurs = np.zeros(nb_valeurs, dtype=np.int32)
# Lecture avec les pointeurs partages en mode individuel
fh.Seek_shared(0, MPI.SEEK_SET)
fh.Read_shared([valeurs, nb_valeurs, MPI.INT])
filename = f"file_ppi{rang}.dat"
np.savetxt(filename, valeurs, fmt='%3d')

# Fermeture du fichier
fh.Close()
